
	!addr = !Base2
    !rom = !BankB

;########################################
;######## Scratchs Rams [$00,$0F] #######
;########################################
!Scratch0 = $00
!Scratch1 = $01
!Scratch2 = $02
!Scratch3 = $03
!Scratch4 = $04
!Scratch5 = $05
!Scratch6 = $06
!Scratch7 = $07
!Scratch8 = $08
!Scratch9 = $09
!ScratchA = $0A
!ScratchB = $0B
!ScratchC = $0C
!ScratchD = $0D
!ScratchE = $0E
!ScratchF = $0F

;########################################
;############## Counters ################
;########################################
!TrueFrameCounter = $13
!EffectiveFrameCounter = $14

;########################################
;############## Control #################
;########################################
!ButtonPressed_BYETUDLR = $15
!ButtonDown_BYETUDLR = $16
!ButtonPressed_AXLR0000 = $17
!ButtonDown_AXLR0000 = $18

;########################################
;############## Layers ##################
;########################################
!Layer1X = $1A
!Layer1Y = $1C
!Layer2X = $1E
!Layer2Y = $20
!Layer3X = $22
!Layer3Y = $24

;########################################
;############## Player ##################
;########################################
!PlayerX = $94
!PlayerY = $96
!PlayerXSpeed = $7B
!PlayerYSpeed = $7D
!PowerUp = $19
!Lives = $0DBE|!addr
!Coins = $0DBF|!addr
!ItemBox = $0DC2|!addr
!PlayerInAirFlag = $72
!PlayerDuckingFlag = $73
!PlayerClimbingFlag_N00SIFHB = $74
!PlayerWaterFlag = $75
!PlayerDirection = $76
!PlayerBlockedStatus_S00MUDLR = $77
!PlayerHide_DLUCAPLU = $78
!CurrentPlayer = $0DB3|!addr
!CapeImage = $13DF|!addr
!PlayerPose = $13E0|!addr
!PlayerSlope = $13E1|!addr
!SpinjumpTimer = $13E2|!addr
!PlayerWallRunningFlag = $13E3|!addr
!PlayerFrozenFlag = $13FB|!addr
!PlayerCarryingFlag = $1470|!addr
!PlayerCarryingFlagImage = $148F|!addr
!PlayerAnimationTimer = $1496|!addr
!PlayerFlashingTimer = $1497|!addr
!P1PowerUp = $0DB8|!addr
!P2PowerUp = $0DB9|!addr
!P1Lives = $0DB4|!addr
!P2Lives = $0DB5|!addr
!P1Coins = $0DB6|!addr
!P2Coins = $0DB7|!addr
!P1YoshiColor = $0DBA|!addr
!P2YoshiColor = $0DBB|!addr
!P1ItemBox = $0DBC|!addr
!P2ItemBox = $0DBD|!addr

;########################################
;############### Global #################
;########################################
!LockAnimationFlag = $9D
!HScrollEnable = $1411|!addr
!VScrollEnable = $1412|!addr
!HScrollLayer2Type = $1413|!addr
!VScrollLayer2Type = $1414|!addr
!WaterFlag = $85
!SlipperyFlag = $86
!GameMode = $0100|!addr
!TwoPlayersFlag = $0DB2|!addr

;########################################
;################ OAM ###################
;########################################
!TileXPosition200 = $0200|!addr
!TileYPosition200 = $0201|!addr
!TileCode200 = $0202|!addr
!TileProperty200 = $0203|!addr
!TileSize420 = $0420|!addr
!TileXPosition = $0300|!addr
!TileYPosition = $0301|!addr
!TileCode = $0302|!addr
!TileProperty = $0303|!addr
!TileSize460 = $0460|!addr

;########################################
;############### Yoshi ##################
;########################################
!YoshiX = $18B0|!addr
!YoshiY = $18B2|!addr
!YoshiKeyInMouthFlag = $191C|!addr

;########################################
;############## Clusters ################
;########################################
!ClusterNumber = $1892|!addr
!ClusterXLow = $1E16|!addr
!ClusterYLow = $1E02|!addr
!ClusterXHigh = $1E3E|!addr
!ClusterYHigh = $1E2A|!addr
!ClusterMiscTable1 = $0F4A|!addr
!ClusterMiscTable2 = $0F5E|!addr
!ClusterMiscTable3 = $0F72|!addr
!ClusterMiscTable4 = $0F86|!addr
!ClusterMiscTable5 = $0F9A|!addr
!ClusterMiscTable6 = $1E52|!addr
!ClusterMiscTable7 = $1E66|!addr
!ClusterMiscTable8 = $1E7A|!addr
!ClusterMiscTable9 = $1E8E|!addr

;########################################
;############## Extended ################
;########################################
!ExtendedNumber = $170B|!addr
!ExtendedXLow = $171F|!addr
!ExtendedYLow = $1715|!addr
!ExtendedXHigh = $1733|!addr
!ExtendedYHigh = $1729|!addr
!ExtendedXSpeed = $1747|!addr
!ExtendedYSpeed = $173D|!addr
!ExtendedXSpeedAccumulatingFraction = $175B|!addr
!ExtendedYSpeedAccumulatingFraction = $1751|!addr
!ExtendedBehindLayersFlag = $1779|!addr
!ExtendedMiscTable1 = $1765|!addr
!ExtendedMiscTable2 = $176F|!addr

;########################################
;############### Sprites ################
;########################################
!SpriteIndex = $15E9|!Base2
!SpriteNumber = $9E
!SpriteStatus = !14C8
!SpriteXLow = !E4
!SpriteYLow = !D8
!SpriteXHigh = !14E0
!SpriteYHigh = !14D4
!SpriteXSpeed = !B6
!SpriteYSpeed = !AA
!SpriteXSpeedAccumulatingFraction = $14F8
!SpriteYSpeedAccumulatingFraction = $14EC
!SpriteDirection = $157C
!SpriteBlockedStatus_ASB0UDLR = $1588
!SpriteHOffScreenFlag = !15A0
!SpriteVOffScreenFlag = !186C
!SpriteHMoreThan4TilesOffScreenFlag = !15C4
!SpriteSlope = $15B8
!SpriteYoshiTongueFlag = $15D0
!SpriteInteractionWithObjectEnable = $15DC
!SpriteIndexOAM = $15EA
!SpriteProperties_YXPPCCCT = $15F6
!SpriteLoadStatus = $161A
!SpriteBehindEscenaryFlag = !1632
!SpriteInLiquidFlag = $164A
!SpriteDecTimer1 = !1540
!SpriteDecTimer2 = !154C
!SpriteDecTimer3 = !1558
!SpriteDecTimer4 = !1564
!SpriteDecTimer5 = !15AC
!SpriteDecTimer6 = !163E
!SpriteDecTimer7 = !1FE2
!SpriteTweaker1656_SSJJCCCC = !1656
!SpriteTweaker1662_DSCCCCCC = !1662
!SpriteTweaker166E_LWCFPPPG = !166E
!SpriteTweaker167A_DPMKSPIS = !167A
!SpriteTweaker1686_DNCTSWYE = !1686
!SpriteTweaker190F_WCDJ5SDP = !190F
!SpriteMiscTable3 = !C2
!SpriteMiscTable4 = !1504
!SpriteMiscTable5 = !1510
!SpriteMiscTable6 = !151C
!SpriteMiscTable7 = !1528
!SpriteMiscTable8 = !1534
!SpriteMiscTable9 = !1570
!SpriteMiscTable10 = !1594
!SpriteMiscTable11 = !1602
!SpriteMiscTable12 = !160E
!SpriteMiscTable13 = !1626
!SpriteMiscTable14 = !187B
!SpriteMiscTable15 = !1FD6

;########################################
;############### GIEPY ##################
;########################################
!ExtraBits = !7FAB10
!NewCodeFlag = !7FAB1C
!ExtraProp1 = !7FAB28
!ExtraProp2 = !7FAB34
!ExtraByte1 = !7FAB40
!ExtraByte2 = !7FAB4C
!ExtraByte3 = !7FAB58
!ExtraByte4 = !7FAB64
!ShooterExtraByte = $7FAB70
!GeneratorExtraByte = $7FAB78
!ScrollerExtraByte = $7FAB79
!CustomSpriteNumber = $7FAB9E
!ShooterExtraBits = $7FABAA
!GeneratorExtraBits = $7FABB2
!Layer1ExtraBits = $7FABB3
!Layer2ExtraBits = $7FABB4
!SpriteFlags = $7FABB5

;######################################
;############## Defines ###############
;######################################

!FrameIndex = !SpriteMiscTable3
!AnimationTimer = !SpriteDecTimer1
!AnimationIndex = !SpriteMiscTable7
!AnimationFrameIndex = !SpriteMiscTable6
!LocalFlip = !SpriteMiscTable4
!GlobalFlip = !SpriteMiscTable5

;######################################
;########### Init Routine #############
;######################################
print "INIT ",pc
	LDA #$00
	STA !GlobalFlip,x
	JSL InitWrapperChangeAnimationFromStart
    ;Here you can write your Init Code
    ;This will be excecuted when the sprite is spawned

	LDA #$78 : STA !sprite_x_low,x
RTL

;######################################
;########## Main Routine ##############
;######################################
print "MAIN ",pc
    PHB
    PHK
    PLB
    JSR SpriteCode
    PLB
RTL

;>Routine: SpriteCode
;>Description: This routine excecute the logic of the sprite
;>RoutineLength: Short
Return:
RTS
SpriteCode:

    JSR GraphicRoutine                  ;Calls the graphic routine and updates sprite graphics

    ;Here you can put code that will be excecuted each frame even if the sprite is locked

    LDA !SpriteStatus,x			        
	CMP #$08                            ;if sprite dead return
	BNE Return	

	LDA !LockAnimationFlag				    
	BNE Return			                    ;if locked animation return.

    ;JSR InteractMarioSprite
    ;After this routine, if the sprite interact with mario, Carry is Set.

    ;Here you can write your sprite code routine
    ;This will be excecuted once per frame excepts when 
    ;the animation is locked or when sprite status is not #$08

    JSR AnimationRoutine                ;Calls animation routine and decides the next frame to draw
    
    RTS

;>EndRoutine

;######################################
;######## Sub Routine Space ###########
;######################################

;Here you can write routines or tables

;Don't Delete or write another >Section Graphics or >End Section
;All code between >Section Graphics and >End Graphics Section will be changed by Dyzen : Sprite Maker
;>Section Graphics
;######################################
;########## Graphics Space ############
;######################################

;This space is for routines used for graphics
;if you don't know enough about asm then
;don't edit them.

;>Routine: GraphicRoutine
;>Description: Updates tiles on the oam map
;results will be visible the next frame.
;>RoutineLength: Short
GraphicRoutine:

    %GetDrawInfo()                     ;Calls GetDrawInfo to get the free slot and the XDisp and YDisp

    STZ !Scratch3                       ;$02 = Free Slot but in 16bits
    STY !Scratch2


    STZ !Scratch5
    LDA !GlobalFlip,x   
    ASL
    STA !Scratch4                       ;$04 = Global Flip but in 16bits


    PHX                                 ;Preserve X
    
    STZ !Scratch7
    LDA !FrameIndex,x
    STA !Scratch6                       ;$06 = Frame Index but in 16bits

    REP #$30                            ;A/X/Y 16bits mode
    LDY !Scratch4                       ;Y = Global Flip
    LDA !Scratch6
    ASL
	CLC
    ADC FramesFlippers,y
    TAX                                 ;X = Frame Index

    LDA FramesLength,x
    CMP #$FFFF
    BNE +
    SEP #$30
    PLX
    RTS
+
    STA !Scratch8

    LDA FramesEndPosition,x
    STA !Scratch4                       ;$04 = End Position + A value used to select a frame version that is flipped

    LDA FramesStartPosition,x           
    TAX                                 ;X = Start Position
    SEP #$20                            ;A 8bits mode
    LDY !Scratch2                       ;Y = Free Slot
    CPY #$00FD
    BCS .return                         ;Y can't be more than #$00FD
-
    LDA Tiles,x
    STA !TileCode,y                     ;Set the Tile code of the tile Y

    LDA Properties,x
    STA !TileProperty,y                 ;Set the Tile property of the tile Y

    LDA !Scratch0
	CLC
	ADC XDisplacements,x
	STA !TileXPosition,y                ;Set the Tile x pos of the tile Y

    LDA !Scratch1
	CLC
	ADC YDisplacements,x
	STA !TileYPosition,y                ;Set the Tile y pos of the tile Y

    PHY
	REP #$20                                 
    TYA
    LSR
    LSR
    TAY                                 ;Y = Y/4 because size directions are not continuous to map 200 and 300
	SEP #$20
    LDA Sizes,x
    STA !TileSize460,y                  ;Set the Tile size of the tile Y
    PLY

    INY
    INY
    INY
    INY                                 ;Next OAM Slot
    CPY #$00FD
    BCS .return                         ;Y can't be more than #$00FD

    DEX
    BMI .return
    CPX !Scratch4                       ;if X < start position or is negative then return
    BCS -                               ;else loop

.return
    SEP #$10
    PLX                                 ;Restore X
    
    LDY #$FF                            ;Allows mode of 8 or 16 bits
    LDA !Scratch8                       ;Load the number of tiles used by the frame
    JSL $01B7B3|!rom                  		;This insert the new tiles into the oam, 
                                        ;A = #$00 => only tiles of 8x8, A = #$02 = only tiles of 16x16, A = #$04 = tiles of 8x8 or 16x16
                                        ;if you select A = #$04 then you must put the sizes of the tiles in !TileSize
RTS
;>EndRoutine

;All words that starts with '@' and finish with '.' will be replaced by Dyzen

;>Table: FramesLengths
;>Description: How many tiles use each frame.
;>ValuesSize: 16
FramesLength:
    dw $001E,$001E,$0026,$0024,$0025,$001F,$0021
	dw $001E,$001E,$0026,$0024,$0025,$001F,$0021
;>EndTable


;>Table: FramesFlippers
;>Description: Values used to add values to FramesStartPosition and FramesEndPosition
;To use a flipped version of the frames.
;>ValuesSize: 16
FramesFlippers:
    dw $0000,$000E
;>EndTable


;>Table: FramesStartPosition
;>Description: Indicates the index where starts each frame
;>ValuesSize: 16
FramesStartPosition:
    dw $001E,$003D,$0064,$0089,$00AF,$00CF,$00F1
	dw $0110,$012F,$0156,$017B,$01A1,$01C1,$01E3
;>EndTable

;>Table: FramesEndPosition
;>Description: Indicates the index where end each frame
;>ValuesSize: 16
FramesEndPosition:
    dw $0000,$001F,$003E,$0065,$008A,$00B0,$00D0
	dw $00F2,$0111,$0130,$0157,$017C,$01A2,$01C2
;>EndTable


;>Table: Tiles
;>Description: Tiles codes of each tile of each frame
;>ValuesSize: 8
Tiles:
    
Frame0_ZiggIdle_Tiles:
	db $00,$20,$40,$60,$01,$21,$41,$61,$82,$A2,$84,$A4,$A0,$EB,$ED,$80
	db $A0,$82,$A2,$84,$A4,$86,$A6,$03,$04,$6B,$6D,$6E,$AD,$BD,$BC
Frame1_ZiggIdle2_Tiles:
	db $00,$20,$40,$60,$01,$21,$41,$61,$82,$A2,$84,$A4,$A0,$EB,$ED,$80
	db $A0,$82,$A2,$84,$A4,$86,$A6,$03,$04,$6B,$6D,$6E,$AD,$BD,$BC
Frame2_ZiggDance1_Tiles:
	db $23,$43,$63,$24,$44,$64,$A6,$C6,$A8,$C8,$D8,$A9,$C9,$D9,$BB,$CB
	db $C0,$C1,$8E,$06,$16,$36,$08,$28,$76,$66,$EB,$ED,$EE,$AD,$CD,$AE
	db $CE,$E0,$E2,$E4,$C0,$C2,$C3
Frame3_ZiggDance2_Tiles:
	db $23,$43,$63,$24,$44,$64,$A6,$C6,$D6,$A8,$C8,$D8,$A9,$C9,$D9,$BB
	db $CB,$C0,$C1,$88,$8A,$8C,$8E,$C9,$CA,$C6,$E6,$C7,$E7,$06,$16,$08
	db $76,$66,$6B,$37,$68
Frame4_ZiggDance3_Tiles:
	db $23,$43,$63,$24,$44,$64,$A6,$C6,$D6,$A8,$C8,$D8,$A9,$C9,$D9,$BB
	db $CB,$C0,$C1,$88,$8A,$8C,$8E,$C9,$CA,$E6,$06,$16,$08,$76,$66,$6B
	db $37,$68,$AD,$BD,$AE,$BE
Frame5_ZiggLaugh1_Tiles:
	db $00,$20,$40,$60,$01,$21,$41,$61,$80,$A0,$82,$A2,$A4,$03,$04,$6B
	db $6D,$6E,$85,$A5,$86,$A6,$80,$A0,$82,$A2,$84,$A4,$86,$AD,$BD,$BC
Frame6_ZiggLaugh2_Tiles:
	db $20,$40,$60,$41,$61,$80,$03,$04,$6B,$6D,$6E,$80,$A0,$82,$A2,$84
	db $A4,$AD,$BD,$BC,$00,$22,$32,$42,$86,$87,$80,$A0,$82,$A2,$84,$A4
	db $86,$A6
Frame0_ZiggIdle_TilesFlipX:
	db $00,$20,$40,$60,$01,$21,$41,$61,$82,$A2,$84,$A4,$A0,$EB,$ED,$80
	db $A0,$82,$A2,$84,$A4,$86,$A6,$03,$04,$6B,$6D,$6E,$AD,$BD,$BC
Frame1_ZiggIdle2_TilesFlipX:
	db $00,$20,$40,$60,$01,$21,$41,$61,$82,$A2,$84,$A4,$A0,$EB,$ED,$80
	db $A0,$82,$A2,$84,$A4,$86,$A6,$03,$04,$6B,$6D,$6E,$AD,$BD,$BC
Frame2_ZiggDance1_TilesFlipX:
	db $23,$43,$63,$24,$44,$64,$A6,$C6,$A8,$C8,$D8,$A9,$C9,$D9,$BB,$CB
	db $C0,$C1,$8E,$06,$16,$36,$08,$28,$76,$66,$EB,$ED,$EE,$AD,$CD,$AE
	db $CE,$E0,$E2,$E4,$C0,$C2,$C3
Frame3_ZiggDance2_TilesFlipX:
	db $23,$43,$63,$24,$44,$64,$A6,$C6,$D6,$A8,$C8,$D8,$A9,$C9,$D9,$BB
	db $CB,$C0,$C1,$88,$8A,$8C,$8E,$C9,$CA,$C6,$E6,$C7,$E7,$06,$16,$08
	db $76,$66,$6B,$37,$68
Frame4_ZiggDance3_TilesFlipX:
	db $23,$43,$63,$24,$44,$64,$A6,$C6,$D6,$A8,$C8,$D8,$A9,$C9,$D9,$BB
	db $CB,$C0,$C1,$88,$8A,$8C,$8E,$C9,$CA,$E6,$06,$16,$08,$76,$66,$6B
	db $37,$68,$AD,$BD,$AE,$BE
Frame5_ZiggLaugh1_TilesFlipX:
	db $00,$20,$40,$60,$01,$21,$41,$61,$80,$A0,$82,$A2,$A4,$03,$04,$6B
	db $6D,$6E,$85,$A5,$86,$A6,$80,$A0,$82,$A2,$84,$A4,$86,$AD,$BD,$BC
Frame6_ZiggLaugh2_TilesFlipX:
	db $20,$40,$60,$41,$61,$80,$03,$04,$6B,$6D,$6E,$80,$A0,$82,$A2,$84
	db $A4,$AD,$BD,$BC,$00,$22,$32,$42,$86,$87,$80,$A0,$82,$A2,$84,$A4
	db $86,$A6
;>EndTable


;>Table: Properties
;>Description: Properties of each tile of each frame
;>ValuesSize: 8
Properties:
    
Frame0_ZiggIdle_Properties:
	db $2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2F
	db $2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2E,$2E,$2E
Frame1_ZiggIdle2_Properties:
	db $2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2F
	db $2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2E,$2E,$2E
Frame2_ZiggDance1_Properties:
	db $2F,$2F,$2F,$2F,$2F,$2F,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E
	db $2E,$2E,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F
	db $2F,$2F,$2F,$2F,$2F,$2F,$2F
Frame3_ZiggDance2_Properties:
	db $2F,$2F,$2F,$2F,$2F,$2F,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E
	db $2E,$2E,$2E,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F
	db $2F,$2F,$2F,$2F,$2F
Frame4_ZiggDance3_Properties:
	db $2F,$2F,$2F,$2F,$2F,$2F,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E
	db $2E,$2E,$2E,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F
	db $2F,$2F,$2F,$2F,$2F,$2F
Frame5_ZiggLaugh1_Properties:
	db $2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F
	db $2F,$2F,$2F,$2F,$2F,$2F,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E,$2E
Frame6_ZiggLaugh2_Properties:
	db $2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2F,$2E,$2E,$2E,$2E,$2E
	db $2E,$2E,$2E,$2E,$2F,$2F,$2F,$2F,$2E,$2E,$2F,$2F,$2F,$2F,$2F,$2F
	db $2F,$2F
Frame0_ZiggIdle_PropertiesFlipX:
	db $6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6F
	db $6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6E,$6E,$6E
Frame1_ZiggIdle2_PropertiesFlipX:
	db $6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6F
	db $6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6E,$6E,$6E
Frame2_ZiggDance1_PropertiesFlipX:
	db $6F,$6F,$6F,$6F,$6F,$6F,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E
	db $6E,$6E,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F
	db $6F,$6F,$6F,$6F,$6F,$6F,$6F
Frame3_ZiggDance2_PropertiesFlipX:
	db $6F,$6F,$6F,$6F,$6F,$6F,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E
	db $6E,$6E,$6E,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F
	db $6F,$6F,$6F,$6F,$6F
Frame4_ZiggDance3_PropertiesFlipX:
	db $6F,$6F,$6F,$6F,$6F,$6F,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E
	db $6E,$6E,$6E,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F
	db $6F,$6F,$6F,$6F,$6F,$6F
Frame5_ZiggLaugh1_PropertiesFlipX:
	db $6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F
	db $6F,$6F,$6F,$6F,$6F,$6F,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E,$6E
Frame6_ZiggLaugh2_PropertiesFlipX:
	db $6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6F,$6E,$6E,$6E,$6E,$6E
	db $6E,$6E,$6E,$6E,$6F,$6F,$6F,$6F,$6E,$6E,$6F,$6F,$6F,$6F,$6F,$6F
	db $6F,$6F
;>EndTable
;>Table: XDisplacements
;>Description: X Displacement of each tile of each frame
;>ValuesSize: 8
XDisplacements:
    
Frame0_ZiggIdle_XDisp:
	db $00,$00,$00,$00,$08,$08,$08,$08,$00,$00,$10,$10,$F0,$F7,$07,$E7
	db $E7,$F7,$F7,$07,$07,$17,$17,$00,$08,$F8,$08,$10,$F8,$F8,$F0
Frame1_ZiggIdle2_XDisp:
	db $00,$00,$00,$00,$08,$08,$08,$08,$00,$00,$10,$10,$F0,$F7,$07,$E7
	db $E7,$F7,$F7,$07,$07,$17,$17,$00,$08,$F8,$08,$10,$F8,$F8,$F0
Frame2_ZiggDance1_XDisp:
	db $FE,$FF,$FF,$06,$07,$07,$ED,$ED,$FD,$FD,$FD,$05,$05,$05,$15,$15
	db $F5,$FD,$F8,$FF,$FE,$F6,$0E,$0C,$16,$16,$0E,$1E,$26,$1C,$1D,$24
	db $25,$D0,$E0,$F0,$C8,$D8,$E0
Frame3_ZiggDance2_XDisp:
	db $FE,$FE,$FE,$06,$06,$06,$ED,$ED,$ED,$FD,$FD,$FD,$05,$05,$05,$15
	db $15,$F5,$FD,$C8,$D8,$E8,$F8,$0F,$17,$1D,$1D,$25,$25,$FE,$FE,$0D
	db $16,$15,$F6,$FE,$0E
Frame4_ZiggDance3_XDisp:
	db $FE,$FE,$FE,$06,$06,$06,$ED,$ED,$ED,$FD,$FD,$FD,$05,$05,$05,$15
	db $15,$F5,$FD,$C8,$D8,$E8,$F8,$0F,$15,$1B,$FE,$FE,$0D,$16,$15,$F6
	db $FE,$0E,$1A,$1A,$22,$22
Frame5_ZiggLaugh1_XDisp:
	db $00,$00,$00,$00,$08,$08,$08,$08,$E7,$E7,$F7,$F7,$07,$00,$08,$F8
	db $08,$10,$0F,$0F,$17,$17,$F0,$F0,$00,$00,$10,$10,$01,$F8,$F8,$F0
Frame6_ZiggLaugh2_XDisp:
	db $00,$00,$00,$08,$08,$E7,$00,$08,$F8,$08,$10,$F0,$F0,$00,$00,$10
	db $10,$F8,$F8,$F0,$01,$10,$10,$10,$01,$09,$E7,$E7,$F7,$F7,$07,$07
	db $17,$17
Frame0_ZiggIdle_XDispFlipX:
	db $00,$00,$00,$00,$F8,$F8,$F8,$F8,$00,$00,$F0,$F0,$10,$09,$F9,$19
	db $19,$09,$09,$F9,$F9,$E9,$E9,$00,$F8,$08,$F8,$F0,$10,$10,$18
Frame1_ZiggIdle2_XDispFlipX:
	db $00,$00,$00,$00,$F8,$F8,$F8,$F8,$00,$00,$F0,$F0,$10,$09,$F9,$19
	db $19,$09,$09,$F9,$F9,$E9,$E9,$00,$F8,$08,$F8,$F0,$10,$10,$18
Frame2_ZiggDance1_XDispFlipX:
	db $02,$01,$01,$FA,$F9,$F9,$13,$13,$03,$03,$03,$FB,$FB,$FB,$F3,$F3
	db $13,$0B,$08,$01,$02,$0A,$F2,$F4,$F2,$F2,$F2,$E2,$DA,$E4,$E3,$DC
	db $DB,$30,$20,$10,$38,$28,$20
Frame3_ZiggDance2_XDispFlipX:
	db $02,$02,$02,$FA,$FA,$FA,$13,$13,$13,$03,$03,$03,$FB,$FB,$FB,$F3
	db $F3,$13,$0B,$38,$28,$18,$08,$F1,$E9,$E3,$E3,$DB,$DB,$02,$02,$F3
	db $F2,$F3,$0A,$0A,$F2
Frame4_ZiggDance3_XDispFlipX:
	db $02,$02,$02,$FA,$FA,$FA,$13,$13,$13,$03,$03,$03,$FB,$FB,$FB,$F3
	db $F3,$13,$0B,$38,$28,$18,$08,$F1,$EB,$E5,$02,$02,$F3,$F2,$F3,$0A
	db $0A,$F2,$E6,$E6,$DE,$DE
Frame5_ZiggLaugh1_XDispFlipX:
	db $00,$00,$00,$00,$F8,$F8,$F8,$F8,$19,$19,$09,$09,$F9,$00,$F8,$08
	db $F8,$F0,$F1,$F1,$E9,$E9,$10,$10,$00,$00,$F0,$F0,$FF,$10,$10,$18
Frame6_ZiggLaugh2_XDispFlipX:
	db $00,$00,$00,$F8,$F8,$19,$00,$F8,$08,$F8,$F0,$10,$10,$00,$00,$F0
	db $F0,$10,$10,$18,$FF,$F8,$F8,$F8,$07,$FF,$19,$19,$09,$09,$F9,$F9
	db $E9,$E9
;>EndTable
;>Table: YDisplacements
;>Description: Y Displacement of each tile of each frame
;>ValuesSize: 8
YDisplacements:
    
Frame0_ZiggIdle_YDisp:
	db $0D,$1D,$2D,$3D,$0D,$1D,$2D,$3D,$EE,$FE,$EE,$FE,$FE,$07,$07,$0C
	db $1C,$0C,$1C,$0C,$1C,$0C,$1C,$4D,$4D,$5D,$5D,$5D,$EE,$F6,$F6
Frame1_ZiggIdle2_YDisp:
	db $0E,$1E,$2E,$3D,$0E,$1E,$2E,$3D,$F0,$00,$F0,$00,$00,$09,$09,$0D
	db $1D,$0D,$1D,$0D,$1D,$0D,$1D,$4D,$4D,$5D,$5D,$5D,$F0,$F8,$F8
Frame2_ZiggDance1_YDisp:
	db $13,$23,$33,$13,$23,$33,$F9,$09,$F9,$09,$11,$F9,$09,$11,$01,$09
	db $F1,$F1,$12,$43,$4B,$5B,$40,$50,$38,$30,$15,$16,$16,$F9,$08,$F9
	db $08,$13,$13,$13,$03,$03,$03
Frame3_ZiggDance2_YDisp:
	db $13,$23,$33,$13,$23,$33,$F8,$08,$11,$F8,$08,$10,$F8,$08,$10,$00
	db $08,$F0,$F0,$12,$12,$12,$12,$11,$11,$F4,$04,$F4,$04,$43,$4B,$40
	db $38,$30,$61,$5B,$4F
Frame4_ZiggDance3_YDisp:
	db $13,$23,$33,$13,$23,$33,$F8,$08,$11,$F8,$08,$10,$F8,$08,$10,$00
	db $08,$F0,$F0,$13,$14,$13,$12,$11,$12,$05,$43,$4B,$40,$38,$30,$61
	db $5B,$4F,$F8,$00,$F8,$00
Frame5_ZiggLaugh1_YDisp:
	db $0D,$1D,$2D,$3D,$0D,$1D,$2D,$3D,$0C,$1C,$0C,$1C,$1C,$4D,$4D,$5D
	db $5D,$5D,$0C,$1C,$0C,$1C,$F0,$00,$F0,$00,$F0,$00,$10,$F0,$F8,$F8
Frame6_ZiggLaugh2_YDisp:
	db $1E,$2E,$3E,$2E,$3E,$0D,$4D,$4D,$5D,$5D,$5D,$F1,$01,$F1,$01,$F1
	db $01,$F1,$F9,$F9,$0E,$1E,$26,$2E,$13,$13,$0E,$1E,$0E,$1E,$0E,$1E
	db $0E,$1E
Frame0_ZiggIdle_YDispFlipX:
	db $0D,$1D,$2D,$3D,$0D,$1D,$2D,$3D,$EE,$FE,$EE,$FE,$FE,$07,$07,$0C
	db $1C,$0C,$1C,$0C,$1C,$0C,$1C,$4D,$4D,$5D,$5D,$5D,$EE,$F6,$F6
Frame1_ZiggIdle2_YDispFlipX:
	db $0E,$1E,$2E,$3D,$0E,$1E,$2E,$3D,$F0,$00,$F0,$00,$00,$09,$09,$0D
	db $1D,$0D,$1D,$0D,$1D,$0D,$1D,$4D,$4D,$5D,$5D,$5D,$F0,$F8,$F8
Frame2_ZiggDance1_YDispFlipX:
	db $13,$23,$33,$13,$23,$33,$F9,$09,$F9,$09,$11,$F9,$09,$11,$01,$09
	db $F1,$F1,$12,$43,$4B,$5B,$40,$50,$38,$30,$15,$16,$16,$F9,$08,$F9
	db $08,$13,$13,$13,$03,$03,$03
Frame3_ZiggDance2_YDispFlipX:
	db $13,$23,$33,$13,$23,$33,$F8,$08,$11,$F8,$08,$10,$F8,$08,$10,$00
	db $08,$F0,$F0,$12,$12,$12,$12,$11,$11,$F4,$04,$F4,$04,$43,$4B,$40
	db $38,$30,$61,$5B,$4F
Frame4_ZiggDance3_YDispFlipX:
	db $13,$23,$33,$13,$23,$33,$F8,$08,$11,$F8,$08,$10,$F8,$08,$10,$00
	db $08,$F0,$F0,$13,$14,$13,$12,$11,$12,$05,$43,$4B,$40,$38,$30,$61
	db $5B,$4F,$F8,$00,$F8,$00
Frame5_ZiggLaugh1_YDispFlipX:
	db $0D,$1D,$2D,$3D,$0D,$1D,$2D,$3D,$0C,$1C,$0C,$1C,$1C,$4D,$4D,$5D
	db $5D,$5D,$0C,$1C,$0C,$1C,$F0,$00,$F0,$00,$F0,$00,$10,$F0,$F8,$F8
Frame6_ZiggLaugh2_YDispFlipX:
	db $1E,$2E,$3E,$2E,$3E,$0D,$4D,$4D,$5D,$5D,$5D,$F1,$01,$F1,$01,$F1
	db $01,$F1,$F9,$F9,$0E,$1E,$26,$2E,$13,$13,$0E,$1E,$0E,$1E,$0E,$1E
	db $0E,$1E
;>EndTable
;>Table: Sizes.
;>Description: size of each tile of each frame
;>ValuesSize: 8
Sizes:
    
Frame0_ZiggIdle_Sizes:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00,$00,$00
Frame1_ZiggIdle2_Sizes:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00,$00,$00
Frame2_ZiggDance1_Sizes:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00,$00
	db $00,$00,$02,$02,$02,$02,$02,$02,$00,$00,$02,$02,$02,$02,$02,$02
	db $02,$02,$02,$02,$02,$02,$02
Frame3_ZiggDance2_Sizes:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00
	db $00,$00,$00,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $00,$00,$02,$00,$02
Frame4_ZiggDance3_Sizes:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00
	db $00,$00,$00,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00,$00,$02
	db $00,$02,$02,$02,$02,$02
Frame5_ZiggLaugh1_Sizes:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00,$00,$00
Frame6_ZiggLaugh2_Sizes:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $02,$00,$00,$00,$02,$00,$00,$00,$00,$00,$02,$02,$02,$02,$02,$02
	db $02,$02
Frame0_ZiggIdle_SizesFlipX:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00,$00,$00
Frame1_ZiggIdle2_SizesFlipX:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00,$00,$00
Frame2_ZiggDance1_SizesFlipX:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00,$00
	db $00,$00,$02,$02,$02,$02,$02,$02,$00,$00,$02,$02,$02,$02,$02,$02
	db $02,$02,$02,$02,$02,$02,$02
Frame3_ZiggDance2_SizesFlipX:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00
	db $00,$00,$00,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $00,$00,$02,$00,$02
Frame4_ZiggDance3_SizesFlipX:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00
	db $00,$00,$00,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00,$00,$02
	db $00,$02,$02,$02,$02,$02
Frame5_ZiggLaugh1_SizesFlipX:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$00,$00,$00
Frame6_ZiggLaugh2_SizesFlipX:
	db $02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02
	db $02,$00,$00,$00,$02,$00,$00,$00,$00,$00,$02,$02,$02,$02,$02,$02
	db $02,$02
;>EndTable

;>End Graphics Section

;Don't Delete or write another >Section Animation or >End Section
;All code between >Section Animations and >End Animations Section will be changed by Dyzen : Sprite Maker
;>Section Animations
;######################################
;########## Animation Space ###########
;######################################

;This space is for routines used for graphics
;if you don't know enough about asm then
;don't edit them.
InitWrapperChangeAnimationFromStart:
	PHB
    PHK
    PLB
	STZ !AnimationIndex,x
	JSR ChangeAnimationFromStart
	PLB
	RTL

ChangeAnimationFromStart_Idle:
	STZ !AnimationIndex,x
	JMP ChangeAnimationFromStart
ChangeAnimationFromStart_Dance:
	LDA #$01
	STA !AnimationIndex,x
	JMP ChangeAnimationFromStart
ChangeAnimationFromStart_Laugh:
	LDA #$02
	STA !AnimationIndex,x


ChangeAnimationFromStart:
	STZ !AnimationFrameIndex,x

	STZ !Scratch1
	LDA !AnimationIndex,x
	STA !Scratch0					;$00 = Animation index in 16 bits

	STZ !Scratch3
	LDA !AnimationFrameIndex,x
	STA !Scratch2					;$02 = Animation Frame index in 16 bits

	STZ !Scratch5
	STX !Scratch4					;$04 = sprite index in 16 bits

	REP #$30						;A7X/Y of 16 bits
	LDX !Scratch4					;X = sprite index in 16 bits

	LDA !Scratch0
	ASL
	TAY								;Y = 2*Animation index

	LDA !Scratch2
	CLC
	ADC AnimationIndexer,y
	TAY								;Y = Position of the first frame of the animation + animation frame index

	SEP #$20						;A of 8 bits

	LDA Frames,y
	STA !FrameIndex,x				;New Frame = Frames[New Animation Frame Index]

	LDA Times,y
	STA !AnimationTimer,x			;Time = Times[New Animation Frame Index]

	LDA !Scratch2
	STA !AnimationFrameIndex,x

	SEP #$10						;X/Y of 8 bits
	LDX !Scratch4					;X = sprite index in 8 bits
RTS
	

;>Routine: AnimationRoutine
;>Description: Decides what will be the next frame.
;>RoutineLength: Short
AnimationRoutine:
    LDA !AnimationTimer,x
    BEQ +

	RTS

+
	STZ !Scratch1
	LDA !AnimationIndex,x
	STA !Scratch0					;$00 = Animation index in 16 bits

	STZ !Scratch3
	LDA !AnimationFrameIndex,x
	STA !Scratch2					;$02 = Animation Frame index in 16 bits

	STZ !Scratch5
	STX !Scratch4					;$04 = sprite index in 16 bits

	REP #$30						;A7X/Y of 16 bits
	LDX !Scratch4					;X = sprite index in 16 bits

	LDA !Scratch0
	ASL
	TAY								;Y = 2*Animation index

	INC !Scratch2					;New Animation Frame Index = Animation Frame Index + 1

	LDA !Scratch2			        ;if Animation Frame index < Animation Lenght then Animation Frame index++
	CMP AnimationLenght,y			;else go to the frame where start the loop.
	BCC +							

	LDA AnimationLastTransition,y
	STA !Scratch2					;New Animation Frame Index = first frame of the loop.

+
	LDA !Scratch2
	CLC
	ADC AnimationIndexer,y
	TAY								;Y = Position of the first frame of the animation + animation frame index

	SEP #$20						;A of 8 bits

	LDA Frames,y
	STA !FrameIndex,x				;New Frame = Frames[New Animation Frame Index]

	LDA Times,y
	STA !AnimationTimer,x			;Time = Times[New Animation Frame Index]

	LDA !Scratch2
	STA !AnimationFrameIndex,x

	SEP #$10						;X/Y of 8 bits
	LDX !Scratch4					;X = sprite index in 8 bits
RTS
;>EndRoutine

;All words that starts with '>' and finish with '.' will be replaced by Dyzen

AnimationLenght:
	dw $0002,$000D,$0002

AnimationLastTransition:
	dw $0000,$0000,$0000

AnimationIndexer:
	dw $0000,$0002,$000F

Frames:
	
Animation0_Idle_Frames:
	db $00,$01
Animation1_Dance_Frames:
	db $02,$02,$03,$02,$04,$02,$04,$03,$02,$04,$04,$02,$03
Animation2_Laugh_Frames:
	db $05,$06

Times:
	
Animation0_Idle_Times:
	db $0F,$0F
Animation1_Dance_Times:
	db $04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04,$04
Animation2_Laugh_Times:
	db $0A,$0A
;>End Animations Section

;Don't Delete or write another >Section Hitbox Interaction or >End Section
;All code between >Section Hitboxes Interaction and >End Hitboxes Interaction Section will be changed by Dyzen : Sprite Maker
;>Section Hitboxes Interaction
;>End Hitboxes Interaction Section